/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTextDivider
implements Component {
    private final ComponentType type;
    private final List<? extends CharSequence> stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextDivider(ComponentType componentType, List<? extends CharSequence> list, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = list;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic uGraphic, Dimension2D dimension2D, Context2D context2D) {
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = StringUtils.getWidth(this.stringsToDisplay);
        int n3 = (n - n2 - 1) / 2;
        String string = " " + ((Object)this.stringsToDisplay.get(0)).toString();
        if (this.fileFormat == FileFormat.UTXT) {
            umlCharArea.drawHLine('\u2550', 2, 0, n, '\u2502', '\u256a');
            umlCharArea.drawStringLR(string, n3, 2);
            umlCharArea.drawHLine('\u2550', 1, n3 - 1, n3 + string.length() + 1, '\u2502', '\u2567');
            umlCharArea.drawHLine('\u2550', 3, n3 - 1, n3 + string.length() + 1, '\u2502', '\u2564');
            umlCharArea.drawStringTB("\u2554\u2563\u255a", n3 - 1, 1);
            umlCharArea.drawStringTB("\u2557\u2560\u255d", n3 + string.length(), 1);
        } else {
            umlCharArea.drawHLine('=', 2, 0, n);
            umlCharArea.drawStringLR(string, n3, 2);
            umlCharArea.drawHLine('=', 1, n3 - 1, n3 + string.length() + 1);
            umlCharArea.drawHLine('=', 3, n3 - 1, n3 + string.length() + 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 4;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

